@extends('layouts.app')
@section('title','Sandbox – Employees')
@section('page-title','Buat Karyawan (Sandbox)')

@section('content')
<div class="max-w-6xl mx-auto">
    {{-- Header Card --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 px-5 py-4 mb-5 flex items-center justify-between">
        <div>
            <h2 class="text-lg font-semibold text-gray-900">Tambah Karyawan – Sandbox</h2>
            <p class="text-sm text-gray-500">Lengkapi informasi personal & employment. Kolom bertanda <span class="text-red-600">*</span> wajib diisi.</p>
        </div>
        <a href="{{ route('talenta.sandbox.employees.index') }}"
           class="inline-flex items-center gap-2 text-sm px-3 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">
           ← Kembali
        </a>
    </div>

    {{-- Global Errors --}}
    @if($errors->any())
        <div class="mb-5 rounded-xl border border-red-200 bg-red-50 text-red-700 px-4 py-3">
            <div class="font-semibold mb-1">Form belum lengkap</div>
            <ul class="list-disc ml-5 text-sm">
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('talenta.sandbox.employees.store') }}" method="POST" class="space-y-6">
        @csrf

        {{-- PERSONAL SECTION --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Informasi Personal</h3>
                <p class="text-sm text-gray-500">Data dasar karyawan.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Employee ID (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Employee ID <span class="text-red-600">*</span>
                    </label>
                    <input type="text" name="employee_id" value="{{ old('employee_id') }}"
                           class="w-full rounded-xl border @error('employee_id') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           required autocomplete="off" placeholder="mis. EMP0001">
                    <p class="text-xs text-gray-500 mt-1">Gunakan format yang konsisten (contoh: EMP0001).</p>
                    @error('employee_id')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- First Name (required) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        First Name <span class="text-red-600">*</span>
                    </label>
                    <input type="text" name="first_name" value="{{ old('first_name') }}"
                           class="w-full rounded-xl border @error('first_name') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           required autocomplete="given-name" placeholder="mis. Budi">
                    @error('first_name')
                        <p class="text-xs text-red-600 mt-1">{{ $message }}</p>
                    @enderror
                </div>

                {{-- Last Name --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Last Name</label>
                    <input type="text" name="last_name" value="{{ old('last_name') }}"
                           class="w-full rounded-xl border border-gray-300 px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           autocomplete="family-name" placeholder="opsional">
                </div>

                {{-- Email --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                    <input type="email" name="email" value="{{ old('email') }}"
                           class="w-full rounded-xl border border-gray-300 px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary"
                           autocomplete="email" placeholder="nama@perusahaan.com">
                    <p class="text-xs text-gray-500 mt-1">Digunakan untuk login & komunikasi.</p>
                </div>
            </div>
        </section>

        {{-- EMPLOYMENT SECTION --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Informasi Employment</h3>
                <p class="text-sm text-gray-500">Pemetaan organisasi & status kerja.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Branch --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Branch</label>
                    <select name="branch_id"
                            class="w-full rounded-xl border border-gray-300 px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary">
                        <option value="">-- Pilih --</option>
                        @foreach(($branches ?? []) as $opt)
                            <option value="{{ $opt['id'] }}" {{ old('branch_id') == $opt['id'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    <p class="text-xs text-gray-500 mt-1">Contoh: Pusat, Cabang Bandung, dsb.</p>
                </div>

                {{-- Organization --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Organization</label>
                    <select name="organization_id"
                            class="w-full rounded-xl border border-gray-300 px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary">
                        <option value="">-- Pilih --</option>
                        @foreach(($orgs ?? []) as $opt)
                            <option value="{{ $opt['id'] }}" {{ old('organization_id') == $opt['id'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    <p class="text-xs text-gray-500 mt-1">Unit / departemen penempatan.</p>
                </div>

                {{-- Job Position --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Job Position</label>
                    <select name="job_position_id"
                            class="w-full rounded-xl border border-gray-300 px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary">
                        <option value="">-- Pilih --</option>
                        @foreach(($jobs ?? []) as $opt)
                            <option value="{{ $opt['id'] }}" {{ old('job_position_id') == $opt['id'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                </div>

                {{-- Job Level (label = name, value = id) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Job Level</label>
                    <select name="job_level_id"
                            class="w-full rounded-xl border border-gray-300 px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary">
                        <option value="">-- Pilih --</option>
                        @foreach(($levels ?? []) as $opt)
                            <option value="{{ $opt['id'] }}" {{ old('job_level_id') == $opt['id'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    <p class="text-xs text-gray-500 mt-1">Contoh: Staff, Supervisor, Manager, CEO.</p>
                </div>

                {{-- Employment Status --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Employment Status</label>
                    <select name="employment_status_id"
                            class="w-full rounded-xl border border-gray-300 px-3 py-2 focus:outline-none focus:ring-4 focus:ring-primary/20 focus:border-primary">
                        <option value="">-- Pilih --</option>
                        @foreach(($emps ?? []) as $opt)
                            <option value="{{ $opt['id'] }}" {{ old('employment_status_id') == $opt['id'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    <p class="text-xs text-gray-500 mt-1">Contoh: Permanent, Contract, Probation.</p>
                </div>
            </div>
        </section>

        {{-- STICKY ACTIONS --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-4 md:p-5 md:sticky md:bottom-4">
            <div class="flex flex-col md:flex-row items-stretch md:items-center justify-between gap-3">
                <p class="text-sm text-gray-500">
                    Pastikan data sudah benar sebelum disimpan.
                </p>
                <div class="flex items-center gap-3">
                    <a href="{{ route('talenta.sandbox.employees.index') }}"
                       class="inline-flex items-center justify-center px-4 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">
                        Batal
                    </a>
                    <button type="submit"
                            class="inline-flex items-center justify-center px-4 py-2 rounded-xl text-white bg-primary hover:opacity-90">
                        Simpan Karyawan
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection
